#ifndef __CTYPES_H__
#define __CTYPES_H__

#include <limits.h>

/* --- general definitions --- */

typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned int uint;
typedef unsigned long ulong;

/* --- size-specific definitions --- */

#if (UCHAR_MAX == 255)
typedef unsigned char byte;
typedef signed char int8;
typedef unsigned char uint8;
#else
#error "8-bit type?"
#endif

#if (SHRT_MAX == 32767)
typedef signed short int16;
typedef unsigned short uint16;
#else
#error "16-bit type?"
#endif

#if (INT_MAX == 2147483647)
typedef signed int int32;
typedef unsigned int uint32;
#elif (LONG_MAX == 2147483647)
typedef signed long int32;
typedef unsigned long uint32;
#else
#error "32-bit type?"
#endif

/* --- helpful macroses --- */

#define ABS(x) ((x) < 0 ? -(x) : (x))

#define MIN(x,y) (((x) < (y)) ? (x) : (y))
#define MAX(x,y) (((x) > (y)) ? (x) : (y))

#define SWAP(type,x,y) {    \
    type t;                 \
                            \
    t = x;                  \
    x = y;                  \
    y = t;                  \
}

#define MEM8(x) *((uint8 *)(x))
#define MEM16(x) *((uint16 *)(x))
#define MEM32(x) *((uint32 *)(x))

#define VMEM8(x) *((volatile uint8 *)(x))
#define VMEM16(x) *((volatile uint16 *)(x))
#define VMEM32(x) *((volatile uint32 *)(x))

#endif
