module AppleTextMode (clk28, CounterY, do_shift, LDPS, charcode, pixelout);

input clk28,do_shift, LDPS;
input [7:0]	 charcode;
input [9:0]  CounterY;
output pixelout;

wire [7:0]  video_shift_data;
reg  [6:0] 	shiftreg;

assign pixelout = shiftreg[0];

charrom_2esmall charrom_2esmall (
	.address( { charcode, CounterY[3:1] }),
	.clock( clk28),
	.q( video_shift_data)
	);



   always @(posedge clk28)
		if (LDPS) begin 
	   		shiftreg <= video_shift_data[6:0];
//	   		high_bit <= video_shift_data[7];
		end  else  if(do_shift ) begin 
	 		shiftreg <= {1'b0,shiftreg[6:1]};
		end


endmodule