module AppleShifter (clk28, CounterY, do_shift, odd_dot, LDPS,  ram_data, pixelout,GR,TEXT, MIXED,
		     vga_R,vga_G,vga_B,AltCharSet,HIRES,
			  flash_count4);

   input clk28,do_shift, odd_dot, LDPS, TEXT, MIXED,AltCharSet,HIRES, flash_count4;
   input [7:0] ram_data;
   input [9:0] CounterY;
   output      pixelout, GR;

   reg [7:0] video_shift_data;
   wire [7:0] char_shift_data;
   reg [7:0] char_code;      
   reg [6:0]  shiftreg; 
   reg [3:0]  low_color_nibble;
   wire [11:0] lowres_color_val;
   output [3:0] vga_R;
   output [3:0] vga_G;
   output [3:0] vga_B;
   reg 		flash, inverse;
   reg 		high_bit;
   wire 	flashing = flash ? flash_count4 : 1'b0;
   reg  	last_pixel;
   

   reg [3:0] 	four_pixels;

  // wire       GR = ~(TEXT || ( MIXED &&  CounterY[6] && CounterY[8]));
	reg GR;
	always @(posedge clk28) begin
		if (LDPS) 
			GR <= ~(TEXT || ( MIXED &&  CounterY[6] && CounterY[8]));
	end		

   wire [6:0] final_char_code = AltCharSet ? char_code : 
	   { (char_code[6] & char_code[7]), char_code[5:0]} ;   

   assign     pixelout =  shiftreg[0] ^ ((inverse ^ flashing) && ~GR);

   charrom_2esmall 
     charrom_2esmall (
		      .address( { final_char_code, CounterY[3:1] }),
		      .clock( clk28),
		      .q( char_shift_data)
		      );
   
   lores_color_map lores_color_map ( 
	.nibble(HIRES ? four_pixels : low_color_nibble), 
	.RGB_val(lowres_color_val)
	);

   reg [11:0] delayed_graphic_data;
   
   wire [3:0] hi_R = shiftreg[0] ? hicolor[11:8] : 4'b0000;
   wire [3:0] hi_G = shiftreg[0] ? hicolor[7:4] : 4'b0000;
   wire [3:0] hi_B = shiftreg[0] ? hicolor[3:0] : 4'b0000;   
    	      

   wire [3:0] mono_pixel = {pixelout,pixelout,pixelout,pixelout};
   
   assign     vga_R = (~GR ) ? mono_pixel :
	      HIRES ? hi_R : delayed_graphic_data[11:8];
   

   assign    vga_G = (~GR ) ? mono_pixel :
	     HIRES ? hi_G : delayed_graphic_data[7:4];
 
   assign     vga_B =  (~GR ) ? mono_pixel : 
	      HIRES ? hi_B : delayed_graphic_data[3:0];

   
   always @(posedge clk28) begin

      if(high_bit == do_shift)
	four_pixels <= {four_pixels[2:0], shiftreg[0]};
      
      
	if(GR)			// no need to check HIRES: we don't shift lowres at all
	  video_shift_data <= char_code; // ram_data; char_code is latched at LDPS
	else
	  video_shift_data <= char_shift_data;
      
	if(LDPS) begin	
	   low_color_nibble <= CounterY[3]? ram_data[7:4] : ram_data[3:0];
   	   char_code <= ram_data;
	   flash  <= AltCharSet ? 0 : (char_code[6] & ~char_code[7]);
	   inverse <=  ~char_code[7]; //	: ~(char_code[7] | (char_code[6] & char_code[7]));
	   delayed_graphic_data <= lowres_color_val;
  
	end
	end

   reg [11:0] hicolor;
   wire       odd = odd_dot ^ CounterY[0];
   
        
   always @(*)
     if(shiftreg[1] | last_pixel) begin
       hicolor <= 12'hfff;
     end else begin
	if(odd) begin
	   if(high_bit)
	     hicolor <= 12'h22f; //med blue
	   else
	     hicolor <= 12'hd2d; // purple
	end else begin
	   if(high_bit)
	     hicolor <= 12'hd03; // red
	   else
	     hicolor <= 12'h1d0; // green
	end
     end

   
   always @(posedge clk28)
     if (LDPS) begin 
	shiftreg <= video_shift_data[6:0];
	high_bit <= video_shift_data[7];
     end  else  if(do_shift ) begin 
	shiftreg <= {1'b0,shiftreg[6:1]};
     end

   always @(posedge clk28)
     if(do_shift ) begin
	last_pixel <= shiftreg[0];
     end
	

endmodule